File: /adapters/cursor/README.md

# Cursor Adapter — SaaS OS Free Edition

This folder contains guidance for using Cursor with SaaS OS Free Edition.

Cursor is treated as an execution assistant.

It does not define system rules.
It does not override contracts.
It does not introduce behavior.

Contracts remain the single source of truth.

---

## Scope (Free Edition)

The Free Edition supports:

- Button contract
- Input contract
- Token-aligned code generation
- Single-file component generation
- Basic landing page construction

It does NOT include:

- Full contract library
- Multi-file orchestration workflows
- Flow-based generation
- Structural refactor pipelines
- Advanced architecture enforcement

Those capabilities are available in SaaS OS Pro.

---

## Folder Structure

This adapter includes:

- `system-rules.md`  
  Minimal execution constraints for Cursor.

- `prompt-pack-basic.md`  
  Safe prompt patterns for single-component generation.

- `examples/`  
  Small, explicit examples for generating Button and Input components.

---

## How to Use

1. Read the relevant contract first.
2. Open your project root in Cursor.
3. Reference the contract explicitly in your prompt.
4. Keep instructions narrow and specific.
5. Validate output against the contract.

If information is missing, generation must stop.

Stopping is correct behavior.

---

## Important Principle

Cursor is replaceable.

If Cursor disappears:
- Contracts still hold.
- Tokens still define styling.
- The system remains stable.

Tools may change.

The system must not.